/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.sound;

import jemu.system.cpc.CPC;

public class AudioFilter {
    int samplerate = 0;
    float[] xv = new float[5];
    float[] yv = new float[5];
    float[] xvb = new float[5];
    float[] yvb = new float[5];
    float[] lxv = new float[5];
    float[] lyv = new float[5];
    float[] lxvb = new float[5];
    float[] lyvb = new float[5];
    float[] lgain = new float[]{3725.5374f, 2400.3887f, 756.6409f, 207.28209f, 71.0137f, 21.467102f, 7.826146f, 3.086545f};
    float[] lamp1 = new float[]{-0.48143458f, -0.43826514f, -0.3192142f, -0.1873795f, -0.09541143f, -0.030118875f, -0.020804841f, -0.10512065f};
    float[] lamp2 = new float[]{2.2757854f, 2.1121554f, 1.6366981f, 1.0546654f, 0.5918063f, 0.1826757f, -0.08646132f, -0.64417714f};
    float[] lamp3 = new float[]{-4.0715513f, -3.8611944f, -3.2112699f, -2.3139884f, -1.485773f, -0.67997855f, -0.53674823f, -1.5857846f};
    float[] lamp4 = new float[]{3.2729056f, 3.1806386f, 2.87264f, 2.369513f, 1.7640694f, 0.7820952f, -0.4004146f, -1.8487071f};
    float[] gain = new float[]{1.1997832f, 1.2280024f, 1.3275825f, 1.5102526f, 1.7694795f, 2.309374f, 3.2389278f, 5.0474687f};
    float[] amp1 = new float[]{-0.6946954f, -0.66313434f, -0.5673839f, -0.43843073f, -0.31938264f, -0.18752757f, -0.09552066f, -0.040515784f};
    float[] amp2 = new float[]{3.0315082f, 2.9244757f, 2.590048f, 2.112791f, 1.6373997f, 1.0553633f, 0.5924018f, 0.26181084f};
    float[] amp3 = new float[]{-4.973334f, -4.85176f, -4.459446f, -3.8620236f, -3.212277f, -2.3151495f, -1.4869195f, -0.82892686f};
    float[] amp4 = new float[]{3.6362052f, 3.5899198f, 3.4351044f, 3.1810088f, 2.8731477f, 2.3702435f, 1.7650644f, 1.0386523f};
    public static boolean lowpass = false;
    public static boolean highpass = false;

    public void setSampleRate(int rate) {
        this.samplerate = rate;
    }

    public int HighpassFilterLeft(int x) {
        if (CPC.tapeRelay && CPC.trueaudio) {
            x ^= 0x80;
        }
        this.xv[0] = this.xv[1];
        this.xv[1] = this.xv[2];
        this.xv[2] = this.xv[3];
        this.xv[3] = this.xv[4];
        this.xv[4] = (float)x / this.gain[this.samplerate];
        this.yv[0] = this.yv[1];
        this.yv[1] = this.yv[2];
        this.yv[2] = this.yv[3];
        this.yv[3] = this.yv[4];
        this.yv[4] = this.xv[0] + this.xv[4] - 4.0f * (this.xv[1] + this.xv[3]) + 6.0f * this.xv[2] + this.amp1[this.samplerate] * this.yv[0] + this.amp2[this.samplerate] * this.yv[1] + this.amp3[this.samplerate] * this.yv[2] + this.amp4[this.samplerate] * this.yv[3];
        x = (int)this.yv[4];
        if (CPC.tapeRelay) {
            x ^= 0x80;
        }
        return x;
    }

    public int HighpassFilterRight(int x) {
        if (CPC.tapeRelay && CPC.trueaudio) {
            x ^= 0x80;
        }
        this.xvb[0] = this.xvb[1];
        this.xvb[1] = this.xvb[2];
        this.xvb[2] = this.xvb[3];
        this.xvb[3] = this.xvb[4];
        this.xvb[4] = (float)x / this.gain[this.samplerate];
        this.yvb[0] = this.yvb[1];
        this.yvb[1] = this.yvb[2];
        this.yvb[2] = this.yvb[3];
        this.yvb[3] = this.yvb[4];
        this.yvb[4] = this.xvb[0] + this.xvb[4] - 4.0f * (this.xvb[1] + this.xvb[3]) + 6.0f * this.xvb[2] + this.amp1[this.samplerate] * this.yvb[0] + this.amp2[this.samplerate] * this.yvb[1] + this.amp3[this.samplerate] * this.yvb[2] + this.amp4[this.samplerate] * this.yvb[3];
        x = (int)this.yvb[4];
        if (CPC.tapeRelay) {
            x ^= 0x80;
        }
        return x;
    }

    public int LowpassFilterLeft(int x) {
        if (CPC.tapeRelay) {
            x ^= 0x80;
        }
        this.lxv[0] = this.lxv[1];
        this.lxv[1] = this.lxv[2];
        this.lxv[2] = this.lxv[3];
        this.lxv[3] = this.lxv[4];
        this.lxv[4] = (float)x / this.lgain[this.samplerate];
        this.lyv[0] = this.lyv[1];
        this.lyv[1] = this.lyv[2];
        this.lyv[2] = this.lyv[3];
        this.lyv[3] = this.lyv[4];
        this.lyv[4] = this.lxv[0] + this.lxv[4] + 4.0f * (this.lxv[1] + this.lxv[3]) + 6.0f * this.lxv[2] + this.lamp1[this.samplerate] * this.lyv[0] + this.lamp2[this.samplerate] * this.lyv[1] + this.lamp3[this.samplerate] * this.lyv[2] + this.lamp4[this.samplerate] * this.lyv[3];
        x = (int)this.lyv[4];
        if (CPC.tapeRelay && CPC.trueaudio) {
            x ^= 0x80;
        }
        return x;
    }

    public int LowpassFilterRight(int x) {
        if (CPC.tapeRelay) {
            x ^= 0x80;
        }
        this.lxvb[0] = this.lxvb[1];
        this.lxvb[1] = this.lxvb[2];
        this.lxvb[2] = this.lxvb[3];
        this.lxvb[3] = this.lxvb[4];
        this.lxvb[4] = (float)x / this.lgain[this.samplerate];
        this.lyvb[0] = this.lyvb[1];
        this.lyvb[1] = this.lyvb[2];
        this.lyvb[2] = this.lyvb[3];
        this.lyvb[3] = this.lyvb[4];
        this.lyvb[4] = this.lxvb[0] + this.lxvb[4] + 4.0f * (this.lxvb[1] + this.lxvb[3]) + 6.0f * this.lxvb[2] + this.lamp1[this.samplerate] * this.lyvb[0] + this.lamp2[this.samplerate] * this.lyvb[1] + this.lamp3[this.samplerate] * this.lyvb[2] + this.lamp4[this.samplerate] * this.lyvb[3];
        x = (int)this.lyvb[4];
        if (CPC.tapeRelay && CPC.trueaudio) {
            x ^= 0x80;
        }
        return x;
    }
}

